/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.DataSourceHelper;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.query.Query;
import com.ibm.icu.util.ULocale;
import javax.servlet.http.HttpServletRequest;

public class DataSourceRequest {
    private Query query;
    private DataSourceParameters dsParams;
    private ULocale userLocale;
    private boolean sameOrigin;
    public static final String SAME_ORIGIN_HEADER = "X-DataSource-Auth";
    public static final String QUERY_REQUEST_PARAMETER = "tq";
    public static final String DATASOURCE_REQUEST_PARAMETER = "tqx";

    private DataSourceRequest() {
    }

    public DataSourceRequest(Query query, DataSourceParameters dataSourceParameters, ULocale uLocale) {
        this.setUserLocale(uLocale);
        this.dsParams = dataSourceParameters;
        this.query = query;
    }

    public DataSourceRequest(HttpServletRequest httpServletRequest) throws DataSourceException {
        this.inferLocaleFromRequest(httpServletRequest);
        this.sameOrigin = DataSourceRequest.determineSameOrigin(httpServletRequest);
        this.createDataSourceParametersFromRequest(httpServletRequest);
        this.createQueryFromRequest(httpServletRequest);
    }

    public static DataSourceRequest getDefaultDataSourceRequest(HttpServletRequest httpServletRequest) {
        DataSourceRequest dataSourceRequest;
        block5: {
            dataSourceRequest = new DataSourceRequest();
            dataSourceRequest.inferLocaleFromRequest(httpServletRequest);
            dataSourceRequest.sameOrigin = DataSourceRequest.determineSameOrigin(httpServletRequest);
            try {
                dataSourceRequest.createDataSourceParametersFromRequest(httpServletRequest);
            }
            catch (DataSourceException dataSourceException) {
                if (dataSourceRequest.dsParams == null) {
                    dataSourceRequest.dsParams = DataSourceParameters.getDefaultDataSourceParameters();
                }
                if (dataSourceRequest.dsParams.getOutputType() != OutputType.JSON || dataSourceRequest.sameOrigin) break block5;
                dataSourceRequest.dsParams.setOutputType(OutputType.JSONP);
            }
        }
        try {
            dataSourceRequest.createQueryFromRequest(httpServletRequest);
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        return dataSourceRequest;
    }

    public static boolean determineSameOrigin(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getHeader(SAME_ORIGIN_HEADER) != null;
    }

    private void createQueryFromRequest(HttpServletRequest httpServletRequest) throws InvalidQueryException {
        String string = httpServletRequest.getParameter(QUERY_REQUEST_PARAMETER);
        this.query = DataSourceHelper.parseQuery(string);
    }

    private void createDataSourceParametersFromRequest(HttpServletRequest httpServletRequest) throws DataSourceException {
        String string = httpServletRequest.getParameter(DATASOURCE_REQUEST_PARAMETER);
        this.dsParams = new DataSourceParameters(string);
        if (this.dsParams.getOutputType() == OutputType.JSON && !this.sameOrigin) {
            this.dsParams.setOutputType(OutputType.JSONP);
        }
    }

    private void inferLocaleFromRequest(HttpServletRequest httpServletRequest) {
        this.userLocale = DataSourceHelper.getLocaleFromRequest(httpServletRequest);
    }

    public Query getQuery() {
        return this.query;
    }

    public DataSourceParameters getDataSourceParameters() {
        return this.dsParams;
    }

    public void setUserLocale(ULocale uLocale) {
        this.userLocale = uLocale;
    }

    public ULocale getUserLocale() {
        return this.userLocale;
    }

    public boolean isSameOrigin() {
        return this.sameOrigin;
    }
}

