/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.value.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TableRow {
    private List<TableCell> cells = Lists.newArrayList();
    private Map<String, String> customProperties = null;

    public void addCell(TableCell tableCell) {
        this.cells.add(tableCell);
    }

    public void addCell(Value value) {
        this.addCell(new TableCell(value));
    }

    public void addCell(double d) {
        this.addCell(new TableCell(d));
    }

    public void addCell(boolean bl) {
        this.addCell(new TableCell(bl));
    }

    public void addCell(String string) {
        this.addCell(new TableCell(string));
    }

    public List<TableCell> getCells() {
        return ImmutableList.copyOf(this.cells);
    }

    public TableCell getCell(int n) {
        return this.cells.get(n);
    }

    TableCell setCell(int n, TableCell tableCell) throws IndexOutOfBoundsException {
        return this.cells.set(n, tableCell);
    }

    public String getCustomProperty(String string) {
        if (this.customProperties == null) {
            return null;
        }
        if (string == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(string);
    }

    public void setCustomProperty(String string, String string2) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (string == null || string2 == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(string, string2);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public TableRow clone() {
        TableRow tableRow = new TableRow();
        for (TableCell object : this.cells) {
            tableRow.addCell(object.clone());
        }
        if (this.customProperties != null) {
            tableRow.customProperties = Maps.newHashMap();
            for (Map.Entry entry : this.customProperties.entrySet()) {
                tableRow.customProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return tableRow;
    }
}

