/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AggregationType {
    SUM("sum"),
    COUNT("count"),
    MIN("min"),
    MAX("max"),
    AVG("avg");

    private String code;
    private static Map<String, AggregationType> codeToAggregationType;

    private AggregationType(String string2) {
        this.code = string2;
    }

    public String getCode() {
        return this.code;
    }

    public static AggregationType getByCode(String string) {
        return codeToAggregationType.get(string);
    }

    static {
        codeToAggregationType = Maps.newHashMap();
        for (AggregationType aggregationType : AggregationType.values()) {
            codeToAggregationType.put(aggregationType.code, aggregationType);
        }
    }
}

