/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit.browser;

import com.sun.webkit.dom.DocumentImpl;
import io.webfolder.ui4j.api.browser.PageConfiguration;
import io.webfolder.ui4j.api.browser.SelectorEngine;
import io.webfolder.ui4j.api.browser.SelectorType;
import io.webfolder.ui4j.api.dom.Document;
import io.webfolder.ui4j.api.dom.Element;
import io.webfolder.ui4j.api.dom.Window;
import io.webfolder.ui4j.api.event.DocumentListener;
import io.webfolder.ui4j.api.event.DocumentLoadEvent;
import io.webfolder.ui4j.api.util.Logger;
import io.webfolder.ui4j.api.util.LoggerFactory;
import io.webfolder.ui4j.spi.EventManager;
import io.webfolder.ui4j.spi.EventRegistrar;
import io.webfolder.ui4j.spi.JavaScriptEngine;
import io.webfolder.ui4j.spi.NativeEventManager;
import io.webfolder.ui4j.spi.PageContext;
import io.webfolder.ui4j.webkit.dom.WebKitDocument;
import io.webfolder.ui4j.webkit.dom.WebKitElement;
import io.webfolder.ui4j.webkit.dom.WebKitPage;
import io.webfolder.ui4j.webkit.dom.WebKitWindow;
import io.webfolder.ui4j.webkit.spi.SizzleSelectorEngine;
import io.webfolder.ui4j.webkit.spi.W3CEventRegistrar;
import io.webfolder.ui4j.webkit.spi.W3CSelectorEngine;
import io.webfolder.ui4j.webkit.spi.WebKitJavaScriptEngine;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.WeakHashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.w3c.dom.Node;

public class WebKitPageContext
implements PageContext {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private EventRegistrar eventRegistrar;
    private EventManager eventManager = new NativeEventManager(this);
    private SelectorEngine selector;
    private PageConfiguration configuration;
    private Map<DocumentImpl, Document> contentDocuments = new WeakHashMap<DocumentImpl, Document>();
    private Map<DocumentImpl, SelectorEngine> selectorEngines = new WeakHashMap<DocumentImpl, SelectorEngine>();

    public WebKitPageContext(PageConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public EventRegistrar getEventRegistrar() {
        return this.eventRegistrar;
    }

    public Element createElement(Object node, Document document, JavaScriptEngine engine) {
        return new WebKitElement((Node)node, document, this, (WebKitJavaScriptEngine)engine);
    }

    public Document createDocument(JavaScriptEngine engine) {
        DocumentImpl documentImpl = (DocumentImpl)((WebKitJavaScriptEngine)engine).getEngine().getDocument();
        WebEngine webEngine = (WebEngine)engine.getEngine();
        if (this.configuration.getUserAgent() != null) {
            webEngine.setUserAgent(this.configuration.getUserAgent());
        }
        webEngine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ExceptionListener(this.log));
        webEngine.setOnError((EventHandler)new DefaultErrorEventHandler());
        WebKitDocument document = new WebKitDocument(this, documentImpl, (WebKitJavaScriptEngine)engine);
        this.selector = this.initializeSelectorEngine(document, (WebKitJavaScriptEngine)engine);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getContentDocument(DocumentImpl documentImpl, JavaScriptEngine engine) {
        WebKitPageContext webKitPageContext = this;
        synchronized (webKitPageContext) {
            Document existingDocument = this.contentDocuments.get(documentImpl);
            if (existingDocument != null) {
                return existingDocument;
            }
            WebKitDocument document = new WebKitDocument(this, documentImpl, (WebKitJavaScriptEngine)engine);
            this.contentDocuments.put(documentImpl, document);
            SelectorEngine selector = this.initializeSelectorEngine(document, (WebKitJavaScriptEngine)engine);
            this.selectorEngines.put(documentImpl, selector);
            return document;
        }
    }

    public void onLoad(Document document) {
        this.eventRegistrar = new W3CEventRegistrar(this);
    }

    public Window createWindow(Document document) {
        return new WebKitWindow(document);
    }

    public WebKitPage newPage(Object view, JavaScriptEngine engine, Window window, Stage stage, Scene scene, Document document, int pageId) {
        WebView webView = (WebView)view;
        WebKitPage page = new WebKitPage(webView, (WebKitJavaScriptEngine)engine, window, stage, scene, document, pageId);
        page.addDocumentListener(new GlobalEventCleaner());
        return page;
    }

    @Override
    public SelectorEngine getSelectorEngine() {
        return this.selector;
    }

    public SelectorEngine getSelectorEngine(org.w3c.dom.Document documentImpl) {
        SelectorEngine contentDocumentSelectorEngine = this.selectorEngines.get(documentImpl);
        if (contentDocumentSelectorEngine == null) {
            return this.selector;
        }
        return contentDocumentSelectorEngine;
    }

    protected SelectorEngine initializeSelectorEngine(Document document, WebKitJavaScriptEngine engine) {
        SelectorEngine selector = null;
        if (this.configuration.getSelectorEngine().equals((Object)SelectorType.SIZZLE)) {
            String sizzle = this.readSizzle();
            boolean foundSizzle = Boolean.parseBoolean(engine.getEngine().executeScript("typeof window.Sizzle === 'function'").toString());
            if (!foundSizzle) {
                engine.getEngine().executeScript(sizzle);
            }
            selector = new SizzleSelectorEngine(this, document, engine);
        } else {
            selector = new W3CSelectorEngine(this, document, engine);
        }
        return selector;
    }

    protected String readSizzle() {
        return this.readFromClasspath("/io/webfolder/ui4j/sizzle.js");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFromClasspath(String path) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(this.getClass().getResourceAsStream(path));){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                return scanner.next();
            }
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public PageConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class DefaultErrorEventHandler
    implements EventHandler<WebErrorEvent> {
        private Logger log = LoggerFactory.getLogger(this.getClass());

        public void handle(WebErrorEvent event) {
            this.log.error("Javascript error: " + event.getMessage());
        }
    }

    public static class ExceptionListener
    implements ChangeListener<Throwable> {
        private Logger log;

        public ExceptionListener(Logger log) {
            this.log = log;
        }

        public void changed(ObservableValue<? extends Throwable> observable, Throwable oldValue, Throwable newValue) {
            this.log.error(newValue.getMessage());
        }
    }

    public static class GlobalEventCleaner
    implements DocumentListener {
        @Override
        public void onLoad(DocumentLoadEvent event) {
            Document document = event.getDocument();
            if (document == null) {
                return;
            }
            List<Element> elements = document.queryAll("[ui4j-registered-event=true]");
            if (elements.isEmpty()) {
                return;
            }
            for (Element next : elements) {
                next.unbind();
                next.removeAttribute("ui4j-registered-event");
                next.removeProperty("events");
            }
        }
    }
}

