/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.api.dom;

import io.webfolder.ui4j.api.dom.Element;
import io.webfolder.ui4j.api.dom.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Select {
    private Element element;

    public Select(Element element) {
        this.element = element;
    }

    public List<Option> getOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        List<Element> list = this.element.getChildren();
        for (Element next : list) {
            if (!next.getTagName().equals("option")) continue;
            options.add(next.getOption().get());
        }
        return options;
    }

    public void clearSelection() {
        this.setSelectedIndex(-1);
        for (Option option : this.getOptions()) {
            option.setSelected(false);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public int getSelectedIndex() {
        int selectedIndex = -1;
        for (Option option : this.getOptions()) {
            ++selectedIndex;
            if (!option.isSelected()) continue;
            return selectedIndex;
        }
        return -1;
    }

    public void setSelectedIndex(int index) {
        this.element.setProperty("selectedIndex", index);
    }

    public Option getOption(int index) {
        List<Option> options = this.getOptions();
        if (options == null || options.isEmpty()) {
            return null;
        }
        return options.get(index);
    }

    public Optional<Option> getSelection() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return Optional.empty();
        }
        return Optional.of(this.getOptions().get(index));
    }

    public Select setDisabled(boolean state) {
        this.getElement().getInput().get().setDisabled(state);
        return this;
    }

    public boolean isDisabled() {
        return this.getElement().getInput().get().isDisabled();
    }

    public void change() {
        this.element.getDocument().trigger("change", this.getElement());
    }
}

