/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Objects;
import javafx.application.Application;

public class ApplicationLauncher {
    private static final String PROPERTY_JAVAFX_MACOSX_EMBEDDED = "javafx.macosx.embedded";
    private static final String PROPERTY_UI4J_HEADLESS = "ui4j.headless";
    private static final String PLATFORM_FACTORY = "com.sun.glass.ui.PlatformFactory";
    private static final String MONOCLE_PLATFORM_FACTORY = "com.sun.glass.ui.monocle.MonoclePlatformFactory";
    private static final String NATIVE_PLATFORM_FACTORY = "com.sun.glass.ui.monocle.NativePlatformFactory";
    private static final String HEADLESS_PLATFORM = "com.sun.glass.ui.monocle.headless.HeadlessPlatform";
    private static final String HEADLESS_PLATFORM_U40 = "com.sun.glass.ui.monocle.HeadlessPlatform";

    public void launch(Class<? extends Application> appClass, String ... appArgs) {
        this.initMacosxEmbedded();
        this.initMonocleHeadless();
        Application.launch(appClass, (String[])appArgs);
    }

    private void initMacosxEmbedded() {
        if (this.checkSystemPropertyEquals(PROPERTY_JAVAFX_MACOSX_EMBEDDED, null)) {
            System.setProperty(PROPERTY_JAVAFX_MACOSX_EMBEDDED, "true");
        }
    }

    private void initMonocleHeadless() {
        if (System.getProperty(PROPERTY_UI4J_HEADLESS) != null) {
            try {
                this.assignMonoclePlatform();
                this.assignHeadlessPlatform();
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Monocle headless platform not found", exception);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private boolean checkSystemPropertyEquals(String propertyName, String valueOrNull) {
        return Objects.equals(System.getProperty(propertyName, null), valueOrNull);
    }

    private void assignMonoclePlatform() throws Exception {
        Class<?> platformFactoryClass = Class.forName(PLATFORM_FACTORY);
        Object platformFactoryImpl = Class.forName(MONOCLE_PLATFORM_FACTORY).newInstance();
        this.assignPrivateStaticField(platformFactoryClass, "instance", platformFactoryImpl);
    }

    private void assignHeadlessPlatform() throws Exception {
        Class<?> nativePlatformFactoryClass = Class.forName(NATIVE_PLATFORM_FACTORY);
        try {
            Constructor<?> nativePlatformCtor = Class.forName(HEADLESS_PLATFORM_U40).getDeclaredConstructor(new Class[0]);
            nativePlatformCtor.setAccessible(true);
            this.assignPrivateStaticField(nativePlatformFactoryClass, "platform", nativePlatformCtor.newInstance(new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Constructor<?> nativePlatformCtor = Class.forName(HEADLESS_PLATFORM).getDeclaredConstructor(new Class[0]);
            nativePlatformCtor.setAccessible(true);
            this.assignPrivateStaticField(nativePlatformFactoryClass, "platform", nativePlatformCtor.newInstance(new Object[0]));
        }
    }

    private void assignPrivateStaticField(Class<?> cls, String name, Object value) throws Exception {
        Field field = cls.getDeclaredField(name);
        field.setAccessible(true);
        field.set(cls, value);
        field.setAccessible(false);
    }
}

