/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit;

import com.sun.webkit.network.CookieManager;
import com.sun.webkit.network.URLs;
import com.sun.webkit.network.data.Handler;
import io.webfolder.ui4j.api.browser.BrowserEngine;
import io.webfolder.ui4j.api.browser.BrowserType;
import io.webfolder.ui4j.api.browser.Page;
import io.webfolder.ui4j.api.browser.PageConfiguration;
import io.webfolder.ui4j.api.dom.Document;
import io.webfolder.ui4j.api.dom.Window;
import io.webfolder.ui4j.api.event.DocumentListener;
import io.webfolder.ui4j.api.event.DocumentLoadEvent;
import io.webfolder.ui4j.api.interceptor.Interceptor;
import io.webfolder.ui4j.api.interceptor.Response;
import io.webfolder.ui4j.api.util.Logger;
import io.webfolder.ui4j.api.util.LoggerFactory;
import io.webfolder.ui4j.api.util.Ui4jException;
import io.webfolder.ui4j.spi.PageContext;
import io.webfolder.ui4j.spi.ShutdownListener;
import io.webfolder.ui4j.spi.Ui4jExecutionTimeoutException;
import io.webfolder.ui4j.webkit.ApplicationLauncher;
import io.webfolder.ui4j.webkit.WebKitErrorHandler;
import io.webfolder.ui4j.webkit.WebKitIsolatedCookieHandler;
import io.webfolder.ui4j.webkit.browser.WebKitPageContext;
import io.webfolder.ui4j.webkit.browser.WebKitURLHandler;
import io.webfolder.ui4j.webkit.dom.WebKitPage;
import io.webfolder.ui4j.webkit.spi.WebKitJavaScriptEngine;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import netscape.javascript.JSObject;

class WebKitBrowser
implements BrowserEngine {
    private static CountDownLatch startupLatch = new CountDownLatch(1);
    private static AtomicBoolean launchedJFX = new AtomicBoolean(false);
    private ShutdownListener shutdownListener;
    private AtomicInteger pageCounter = new AtomicInteger(0);
    private static final Logger LOG = LoggerFactory.getLogger(WebKitBrowser.class);

    WebKitBrowser(ShutdownListener shutdownListener) {
        this.shutdownListener = shutdownListener;
        if (!Platform.isFxApplicationThread()) {
            this.start();
        }
    }

    @Override
    public synchronized Page navigate(String url) {
        return this.navigate(url, new PageConfiguration());
    }

    @Override
    public Page navigate(String url, PageConfiguration configuration) {
        WebKitPageContext context = new WebKitPageContext(configuration);
        int pageId = this.pageCounter.incrementAndGet();
        Interceptor interceptor = configuration.getInterceptor();
        String ui4jUrl = url;
        WebKitURLHandler handler = null;
        if (interceptor != null) {
            String ui4jProtocol = "ui4j-" + pageId;
            ui4jUrl = String.valueOf(ui4jProtocol) + ":" + url;
            handler = new WebKitURLHandler(interceptor, configuration.isInterceptAllRequests());
            try {
                Field handlerMap = URLs.class.getDeclaredField("handlerMap");
                handlerMap.setAccessible(true);
                Map handlers = (Map)handlerMap.get(null);
                handlers.put(ui4jProtocol, handler);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new Ui4jException(e);
            }
        }
        CountDownLatch documentReadyLatch = new CountDownLatch(1);
        SyncDocumentListener adapter = new SyncDocumentListener(documentReadyLatch);
        WebViewCreator creator = null;
        if (Platform.isFxApplicationThread()) {
            creator = new WebViewCreator(ui4jUrl, context, adapter, configuration, handler);
            creator.run();
        } else {
            CountDownLatch webViewLatch = new CountDownLatch(1);
            creator = new WebViewCreator(ui4jUrl, context, adapter, webViewLatch, configuration, handler);
            Platform.runLater((Runnable)creator);
            try {
                webViewLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new Ui4jExecutionTimeoutException(e, 10, TimeUnit.SECONDS);
            }
        }
        try {
            documentReadyLatch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new Ui4jExecutionTimeoutException(e, 60, TimeUnit.SECONDS);
        }
        WebView webView = creator.getWebView();
        Stage stage = creator.getStage();
        Scene scene = creator.getScene();
        WebKitPage page = context.newPage(webView, creator.getEngine(), adapter.getWindow(), stage, scene, adapter.getDocument(), pageId);
        return page;
    }

    public synchronized void start() {
        if (launchedJFX.compareAndSet(false, true) && !Platform.isFxApplicationThread()) {
            this.applyURLsHack();
            new LauncherThread().start();
            try {
                startupLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new Ui4jExecutionTimeoutException(e, 10, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (launchedJFX.get()) {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater((Runnable)new ExitRunner(latch));
            this.shutdownListener.onShutdown(this);
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new Ui4jExecutionTimeoutException(e, 10, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public BrowserType getBrowserType() {
        return BrowserType.WebKit;
    }

    private void applyURLsHack() {
        try {
            ConcurrentHashMap<String, Object> handlers = new ConcurrentHashMap<String, Object>();
            handlers.put("about", new com.sun.webkit.network.about.Handler());
            handlers.put("data", new Handler());
            WebKitBrowser.setFinalStatic(URLs.class.getDeclaredField("handlerMap"), handlers);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Ui4jException(e);
        }
    }

    private static void setFinalStatic(Field field, Object newValue) {
        try {
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new Ui4jException(e);
        }
    }

    @Override
    public synchronized void clearCookies() {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler == null) {
            return;
        }
        if (cookieHandler instanceof CookieManager) {
            CookieManager manager = (CookieManager)cookieHandler;
            try {
                Field fieldStore = manager.getClass().getDeclaredField("store");
                fieldStore.setAccessible(true);
                Object store = fieldStore.get(manager);
                Field fieldBuckets = store.getClass().getDeclaredField("buckets");
                fieldBuckets.setAccessible(true);
                Map buckets = (Map)fieldBuckets.get(store);
                buckets.clear();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new Ui4jException(e);
            }
        } else if (cookieHandler instanceof WebKitIsolatedCookieHandler) {
            ((WebKitIsolatedCookieHandler)cookieHandler).clear();
        }
    }

    public static class ApplicationImpl
    extends Application {
        public void start(Stage stage) {
            startupLatch.countDown();
        }
    }

    public static class EmptyObservableValue
    implements ObservableValue {
        public void addListener(InvalidationListener listener) {
        }

        public void removeListener(InvalidationListener listener) {
        }

        public void addListener(ChangeListener listener) {
        }

        public Object getValue() {
            return null;
        }

        public void removeListener(ChangeListener listener) {
        }
    }

    public static class ExitRunner
    implements Runnable {
        private CountDownLatch latch;

        public ExitRunner(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            if (Platform.isFxApplicationThread()) {
                launchedJFX.set(false);
                Platform.exit();
            }
            this.latch.countDown();
        }
    }

    public static class LauncherThread
    extends Thread {
        @Override
        public void run() {
            new ApplicationLauncher().launch(ApplicationImpl.class, new String[0]);
        }
    }

    public static class ProgressListener
    implements ChangeListener<Number> {
        private WebEngine engine;

        public ProgressListener(WebEngine engine) {
            this.engine = engine;
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            double progress = Math.floor((Double)newValue * 100.0);
            if (progress % 5.0 == 0.0 || progress % 10.0 == 0.0) {
                LOG.info(String.format("Loading %s [%d%%]", this.engine.getLocation(), (int)progress));
            }
        }
    }

    public static class SyncDocumentListener
    implements DocumentListener {
        private CountDownLatch latch;
        private Window window;
        private Document document;

        public SyncDocumentListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void onLoad(DocumentLoadEvent event) {
            this.window = event.getWindow();
            this.document = event.getDocument();
            this.latch.countDown();
        }

        public Document getDocument() {
            return this.document;
        }

        public Window getWindow() {
            return this.window;
        }
    }

    public static class WebViewCreator
    implements Runnable {
        private WebView webView;
        private String url;
        private CountDownLatch latch;
        private PageContext context;
        private DocumentListener listener;
        private WebKitJavaScriptEngine engine;
        private PageConfiguration configuration;
        private WebKitURLHandler handler;
        private Stage stage;
        private Scene scene;

        public WebViewCreator(String url, PageContext context, DocumentListener listener, PageConfiguration configuration, WebKitURLHandler handler) {
            this(url, context, listener, null, configuration, handler);
        }

        public WebViewCreator(String url, PageContext context, DocumentListener listener, CountDownLatch latch, PageConfiguration configuration, WebKitURLHandler handler) {
            this.url = url;
            this.latch = latch;
            this.context = context;
            this.listener = listener;
            this.configuration = configuration;
            this.handler = handler;
        }

        @Override
        public void run() {
            this.webView = new WebView();
            this.stage = new Stage();
            this.scene = new Scene((Parent)this.webView, 600.0, 600.0);
            this.stage.setScene(this.scene);
            this.engine = new WebKitJavaScriptEngine(this.webView.getEngine());
            if (this.configuration.getUserAgent() != null) {
                this.engine.getEngine().setUserAgent(this.configuration.getUserAgent());
            }
            if (this.configuration.getAlertHandler() != null) {
                this.engine.getEngine().setOnAlert((EventHandler)new WebKitPage.AlertDelegationHandler(this.configuration.getAlertHandler()));
            }
            if (this.configuration.getPromptHandler() != null) {
                this.engine.getEngine().setPromptHandler((Callback)new WebKitPage.PromptDelegationHandler(this.configuration.getPromptHandler()));
            }
            if (this.configuration.getConfirmHandler() != null) {
                this.engine.getEngine().setConfirmHandler((Callback)new WebKitPage.ConfirmDelegationHandler(this.configuration.getConfirmHandler()));
            }
            this.engine.getEngine().load(this.url);
            WorkerLoadListener loadListener = new WorkerLoadListener(this.engine, this.context, this.listener, this.handler);
            this.webView.getEngine().getLoadWorker().progressProperty().addListener((ChangeListener)new ProgressListener(this.webView.getEngine()));
            if (this.url == null || this.url.trim().equals("about:blank") || this.url.trim().equals("")) {
                loadListener.changed(new EmptyObservableValue(), Worker.State.SCHEDULED, Worker.State.SUCCEEDED);
            } else {
                this.engine.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)loadListener);
            }
            this.installErrorHandler();
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        protected void installErrorHandler() {
            JSObject objWindow = (JSObject)this.engine.getEngine().executeScript("window");
            objWindow.setMember("Ui4jErrorHandler", new WebKitErrorHandler());
            this.engine.getEngine().executeScript("window.onerror = function(message, url, lineNumber) { Ui4jErrorHandler.onError(message, url, lineNumber); return false; }");
        }

        public WebView getWebView() {
            return this.webView;
        }

        public WebKitJavaScriptEngine getEngine() {
            return this.engine;
        }

        public Stage getStage() {
            return this.stage;
        }

        public Scene getScene() {
            return this.scene;
        }
    }

    public static class WorkerLoadListener
    implements ChangeListener<Worker.State> {
        private WebKitPageContext configuration;
        private DocumentListener documentListener;
        private WebKitJavaScriptEngine engine;
        private WebKitURLHandler handler;

        public WorkerLoadListener(WebKitJavaScriptEngine engine, PageContext context, DocumentListener documentListener, WebKitURLHandler handler) {
            this.engine = engine;
            this.configuration = (WebKitPageContext)context;
            this.documentListener = documentListener;
            this.handler = handler;
        }

        public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
            if (newState == Worker.State.SUCCEEDED) {
                Document document = this.configuration.createDocument(this.engine);
                this.configuration.onLoad(document);
                Window window = this.configuration.createWindow(document);
                DocumentLoadEvent event = new DocumentLoadEvent(window);
                this.documentListener.onLoad(event);
                if (this.configuration.getConfiguration().getInterceptor() != null && this.handler != null) {
                    URLConnection connection = this.handler.getConnection();
                    if (this.handler.getConnection() != null) {
                        Map<String, List<String>> headers = connection.getHeaderFields();
                        Response response = new Response(window.getLocation(), Collections.unmodifiableMap(new HashMap<String, List<String>>(headers)));
                        this.configuration.getConfiguration().getInterceptor().afterLoad(response);
                    }
                }
            }
        }
    }
}

