/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit.browser;

import com.sun.webkit.dom.EventImpl;
import com.sun.webkit.dom.MouseEventImpl;
import com.sun.webkit.dom.NodeImpl;
import io.webfolder.ui4j.api.event.EventAdapter;
import io.webfolder.ui4j.api.event.EventHandler;
import io.webfolder.ui4j.spi.PageContext;
import io.webfolder.ui4j.webkit.browser.WebKitPageContext;
import io.webfolder.ui4j.webkit.dom.WebKitElement;
import netscape.javascript.JSObject;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MouseEvent;

public class WebKitEventListener
implements EventListener {
    protected WebKitElement element;
    protected EventHandler handler;
    protected String listenerId;
    protected String event;
    private PageContext context;

    public WebKitEventListener(WebKitElement element, PageContext configuration, String event, EventHandler handler) {
        this.element = element;
        this.context = configuration;
        this.handler = handler;
        this.event = event;
    }

    @Override
    public void handleEvent(Event evt) {
        EventImpl eventImpl = (EventImpl)evt;
        Node target = (Node)((Object)evt.getTarget());
        Node currentTarget = (Node)((Object)evt.getCurrentTarget());
        WebKitElement elementImpl = (WebKitElement)((WebKitPageContext)this.context).createElement(target, this.element.getDocument(), this.element.getEngine());
        WebKitElement currentElementImpl = (WebKitElement)((WebKitPageContext)this.context).createElement(currentTarget, this.element.getDocument(), this.element.getEngine());
        EventAdapter ui4jEvent = new EventAdapter(evt.getType(), elementImpl, currentElementImpl);
        if (eventImpl instanceof MouseEventImpl) {
            MouseEventImpl mouseEventImpl = (MouseEventImpl)eventImpl;
            NodeImpl nodeImpl = (NodeImpl)target;
            JSObject rect = (JSObject)nodeImpl.eval("this.getBoundingClientRect()");
            int left = (int)Math.round(Double.parseDouble(rect.getMember("left").toString()));
            int top = (int)Math.round(Double.parseDouble(rect.getMember("top").toString()));
            int offsetX = mouseEventImpl.getClientX() - left;
            int offsetY = mouseEventImpl.getClientY() - top;
            ui4jEvent.setOffsetX(offsetX);
            ui4jEvent.setOffsetY(offsetY);
            if (evt instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)evt;
                ui4jEvent.setClientX(me.getClientX());
                ui4jEvent.setClientY(me.getClientY());
            }
        }
        this.handler.handle(ui4jEvent);
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public WebKitElement getElement() {
        return this.element;
    }
}

