/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit.spi;

import com.sun.webkit.dom.HTMLElementImpl;
import io.webfolder.ui4j.api.browser.SelectorEngine;
import io.webfolder.ui4j.api.dom.Document;
import io.webfolder.ui4j.api.dom.Element;
import io.webfolder.ui4j.spi.PageContext;
import io.webfolder.ui4j.webkit.browser.WebKitPageContext;
import io.webfolder.ui4j.webkit.dom.WebKitElement;
import io.webfolder.ui4j.webkit.spi.WebKitJavaScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import netscape.javascript.JSObject;
import org.w3c.dom.Node;

public class SizzleSelectorEngine
implements SelectorEngine {
    private WebKitJavaScriptEngine engine;
    private Document document;
    private PageContext context;

    public SizzleSelectorEngine(PageContext context, Document document, WebKitJavaScriptEngine engine) {
        this.context = context;
        this.document = document;
        this.engine = engine;
    }

    @Override
    public Optional<Element> query(String selector) {
        String escapedSelector = selector.replace('\'', '\"');
        JSObject result = (JSObject)this.engine.getEngine().executeScript(String.format("Sizzle('%s')", escapedSelector));
        int length = (Integer)result.getMember("length");
        if (length <= 0) {
            return null;
        }
        Node found = (Node)result.getSlot(0);
        Element element = ((WebKitPageContext)this.context).createElement(found, this.document, this.engine);
        if (element == null) {
            return Optional.empty();
        }
        return Optional.of(element);
    }

    @Override
    public List<Element> queryAll(String selector) {
        String escapedSelector = selector.replace('\'', '\"');
        JSObject result = (JSObject)this.engine.getEngine().executeScript(String.format("Sizzle('%s')", escapedSelector));
        int length = (Integer)result.getMember("length");
        if (length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < length) {
            Node found = (Node)result.getSlot(i);
            Element element = ((WebKitPageContext)this.context).createElement(found, this.document, this.engine);
            elements.add(element);
            ++i;
        }
        return elements;
    }

    @Override
    public Optional<Element> query(Element element, String selector) {
        if (!(element instanceof WebKitElement)) {
            return null;
        }
        String escapedSelector = selector.replace('\'', '\"');
        WebKitElement fxElementImpl = (WebKitElement)element;
        HTMLElementImpl elementImpl = fxElementImpl.getHtmlElement();
        JSObject result = (JSObject)elementImpl.eval("Sizzle('" + escapedSelector + "', this)");
        int length = (Integer)result.getMember("length");
        if (length <= 0) {
            return null;
        }
        Node found = (Node)result.getSlot(0);
        Element ret = ((WebKitPageContext)this.context).createElement(found, this.document, this.engine);
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    @Override
    public List<Element> queryAll(Element element, String selector) {
        if (!(element instanceof WebKitElement)) {
            return Collections.emptyList();
        }
        String escapedSelector = selector.replace('\'', '\"');
        WebKitElement fxElementImpl = (WebKitElement)element;
        HTMLElementImpl elementImpl = fxElementImpl.getHtmlElement();
        JSObject result = (JSObject)elementImpl.eval("Sizzle('" + escapedSelector + "', this)");
        int length = (Integer)result.getMember("length");
        if (length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < length) {
            Node found = (Node)result.getSlot(i);
            Element ret = ((WebKitPageContext)this.context).createElement(found, this.document, this.engine);
            elements.add(ret);
            ++i;
        }
        return elements;
    }
}

