/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;

public class NumberValue
extends Value {
    private static final NumberValue NULL_VALUE = new NumberValue(-9999.0);
    private double value;

    public static NumberValue getNullValue() {
        return NULL_VALUE;
    }

    public NumberValue(double d) {
        this.value = d;
    }

    @Override
    public ValueType getType() {
        return ValueType.NUMBER;
    }

    public double getValue() {
        if (this == NULL_VALUE) {
            throw new NullValueException("This null number has no value");
        }
        return this.value;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        return Double.toString(this.value);
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        NumberValue numberValue = (NumberValue)value;
        if (this.isNull()) {
            return -1;
        }
        if (numberValue.isNull()) {
            return 1;
        }
        return Double.compare(this.value, numberValue.value);
    }

    @Override
    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return new Double(this.value).hashCode();
    }

    @Override
    public Number getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    protected String innerToQueryString() {
        return Double.toString(this.value);
    }
}

