/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryLabels {
    private static final Log log = LogFactory.getLog((String)QueryLabels.class.getName());
    private Map<AbstractColumn, String> columnLabels = Maps.newHashMap();

    public void addLabel(AbstractColumn abstractColumn, String string) throws InvalidQueryException {
        if (this.columnLabels.keySet().contains(abstractColumn)) {
            String string2 = "Column [" + abstractColumn.toString() + "] is " + "specified more than once in LABEL.";
            log.error((Object)string2);
            throw new InvalidQueryException(string2);
        }
        this.columnLabels.put(abstractColumn, string);
    }

    public String getLabel(AbstractColumn abstractColumn) {
        return this.columnLabels.get(abstractColumn);
    }

    public Set<AbstractColumn> getColumns() {
        return ImmutableSet.copyOf(this.columnLabels.keySet());
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columnLabels.keySet()) {
            for (ScalarFunctionColumn scalarFunctionColumn : abstractColumn.getAllScalarFunctionColumns()) {
                if (arrayList.contains(scalarFunctionColumn)) continue;
                arrayList.add(scalarFunctionColumn);
            }
        }
        return arrayList;
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columnLabels.keySet()) {
            arrayList.addAll(abstractColumn.getAllAggregationColumns());
        }
        return arrayList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.columnLabels == null ? 0 : ((Object)this.columnLabels).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryLabels queryLabels = (QueryLabels)object;
        return !(this.columnLabels == null ? queryLabels.columnLabels != null : !((Object)this.columnLabels).equals(queryLabels.columnLabels));
    }

    public String toQueryString() {
        StrBuilder strBuilder = new StrBuilder();
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columnLabels.keySet()) {
            String string = this.columnLabels.get(abstractColumn);
            arrayList.add(abstractColumn.toQueryString() + " " + Query.stringToQueryStringLiteral(string));
        }
        strBuilder.appendWithSeparators((Collection)arrayList, ", ");
        return strBuilder.toString();
    }
}

