/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.api.browser;

import io.webfolder.ui4j.api.browser.BrowserEngine;
import io.webfolder.ui4j.api.browser.BrowserType;
import io.webfolder.ui4j.api.util.Logger;
import io.webfolder.ui4j.api.util.LoggerFactory;
import io.webfolder.ui4j.spi.BrowserProvider;
import io.webfolder.ui4j.spi.ShutdownListener;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class BrowserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserFactory.class);
    private static final ConcurrentMap<BrowserType, BrowserEngine> BROWSERS = new ConcurrentHashMap<BrowserType, BrowserEngine>();
    private static final ShutdownListener SHUTDOWN_LISTENER = new ShutdownAdapter();

    private BrowserFactory() {
    }

    public static synchronized BrowserEngine getBrowser(BrowserType type) {
        if (BROWSERS.containsKey((Object)type)) {
            return (BrowserEngine)BROWSERS.get((Object)type);
        }
        ServiceLoader<BrowserProvider> loader = ServiceLoader.load(BrowserProvider.class);
        for (BrowserProvider provider : loader) {
            provider.setShutdownListener(SHUTDOWN_LISTENER);
            if (!type.equals((Object)provider.getBrowserType())) continue;
            LOG.info("Initializing " + (Object)((Object)type));
            BrowserEngine browser = provider.create();
            BROWSERS.put(type, browser);
        }
        return (BrowserEngine)BROWSERS.get((Object)type);
    }

    public static synchronized BrowserEngine getWebKit() {
        return BrowserFactory.getBrowser(BrowserType.WebKit);
    }

    public static synchronized BrowserEngine getJxBrowser() {
        return BrowserFactory.getBrowser(BrowserType.JxBrowser);
    }

    private static class ShutdownAdapter
    implements ShutdownListener {
        private ShutdownAdapter() {
        }

        @Override
        public void onShutdown(BrowserEngine engine) {
            for (Map.Entry next : BROWSERS.entrySet()) {
                if (!((BrowserEngine)next.getValue()).equals(engine)) continue;
                BROWSERS.remove(next.getKey());
            }
        }
    }
}

