/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.api.util;

import io.webfolder.ui4j.api.util.JulLogger;
import io.webfolder.ui4j.api.util.Logger;
import io.webfolder.ui4j.api.util.Slf4jLogger;
import io.webfolder.ui4j.api.util.Ui4jException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoggerFactory {
    private static Class<?> SLF4J_LOGGER_CLASS;

    public static synchronized Logger getLogger(Class<?> klass) {
        boolean foundSlf4j;
        boolean bl = foundSlf4j = SLF4J_LOGGER_CLASS != null;
        if (foundSlf4j) {
            Method getLoggerMethod = null;
            try {
                getLoggerMethod = SLF4J_LOGGER_CLASS.getMethod("getLogger", Class.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new Ui4jException(e);
            }
            Object slf4jLogger = null;
            try {
                slf4jLogger = getLoggerMethod.invoke(null, klass);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new Ui4jException(e);
            }
            return new Slf4jLogger(slf4jLogger);
        }
        return new JulLogger(klass);
    }

    static {
        try {
            SLF4J_LOGGER_CLASS = Thread.currentThread().getContextClassLoader().loadClass("org.slf4j.LoggerFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

