/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit.aspect;

import io.webfolder.ui4j.api.util.Ui4jException;
import io.webfolder.ui4j.internal.aspectj.lang.NoAspectBoundException;
import io.webfolder.ui4j.internal.aspectj.lang.ProceedingJoinPoint;
import io.webfolder.ui4j.internal.aspectj.lang.annotation.Around;
import io.webfolder.ui4j.internal.aspectj.lang.annotation.Aspect;
import io.webfolder.ui4j.internal.aspectj.lang.reflect.MethodSignature;
import io.webfolder.ui4j.spi.Ui4jExecutionTimeoutException;
import io.webfolder.ui4j.webkit.dom.WebKitDocument;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.web.WebEngine;

@Aspect
public class WebKitAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ WebKitAspect ajc$perSingletonInstance;

    @Around(value="within(io.webfolder.ui4j.webkit.dom..*) && execution(* *(..))")
    public Object intercept(ProceedingJoinPoint jp) throws Throwable {
        Object that = jp.getTarget();
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        if (method.getName().equals("getEngine")) {
            return jp.proceed();
        }
        if (that instanceof WebKitDocument) {
            WebKitDocument document = (WebKitDocument)that;
            boolean loading = false;
            if (Platform.isFxApplicationThread()) {
                loading = document.getEngine().getLoadWorker().isRunning();
            } else {
                CountDownLatch loadingLatch = new CountDownLatch(1);
                LoadingRunner loadingRunner = new LoadingRunner(document.getEngine(), loadingLatch);
                Platform.runLater((Runnable)loadingRunner);
                try {
                    loadingLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new Ui4jExecutionTimeoutException(e, 60, TimeUnit.SECONDS);
                }
                loading = loadingRunner.isLoading();
                if (loading) {
                    CountDownLatch listenerLatch = new CountDownLatch(1);
                    LoadListener listener = new LoadListener(listenerLatch);
                    Platform.runLater(() -> document.getEngine().getLoadWorker().runningProperty().addListener((ChangeListener)listener));
                    try {
                        listenerLatch.await(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new Ui4jExecutionTimeoutException(e, 60, TimeUnit.SECONDS);
                    }
                    Platform.runLater(() -> document.getEngine().getLoadWorker().runningProperty().removeListener((ChangeListener)listener));
                    document.refreshDocument();
                }
            }
        }
        Object ret = null;
        if (!Platform.isFxApplicationThread()) {
            CountDownLatch latch = new CountDownLatch(1);
            CallableExecutor executor = new CallableExecutor(latch, jp);
            Platform.runLater((Runnable)executor);
            try {
                latch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new Ui4jExecutionTimeoutException(e, 60, TimeUnit.SECONDS);
            }
            ret = executor.getResult();
        } else {
            try {
                ret = jp.proceed();
            }
            catch (Exception e) {
                throw new Ui4jException(e);
            }
        }
        return ret;
    }

    public static WebKitAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.webfolder.ui4j.webkit.aspect.WebKitAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            WebKitAspect.ajc$perSingletonInstance = new WebKitAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static class CallableExecutor
    implements Runnable {
        private CountDownLatch latch;
        private ProceedingJoinPoint callable;
        private Object result;

        public CallableExecutor(CountDownLatch latch, ProceedingJoinPoint callable) {
            this.latch = latch;
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                try {
                    this.result = this.callable.proceed();
                }
                catch (Throwable e) {
                    throw new Ui4jException(e);
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public Object getResult() {
            return this.result;
        }
    }

    private static class LoadListener
    implements ChangeListener<Boolean> {
        private CountDownLatch latch;

        public LoadListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.equals(Boolean.FALSE)) {
                this.latch.countDown();
            }
        }
    }

    private static class LoadingRunner
    implements Runnable {
        private WebEngine engine;
        private CountDownLatch latch;
        private boolean loading;

        public LoadingRunner(WebEngine engine, CountDownLatch latch) {
            this.engine = engine;
            this.latch = latch;
        }

        @Override
        public void run() {
            this.loading = this.engine.getLoadWorker().isRunning();
            this.latch.countDown();
        }

        public boolean isLoading() {
            return this.loading;
        }
    }
}

