/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit.browser;

import io.webfolder.ui4j.api.interceptor.Interceptor;
import io.webfolder.ui4j.api.interceptor.Request;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WebKitURLHandler
extends URLStreamHandler {
    private String context;
    private static final String UI4J_PROTOCOL = "ui4j";
    private Interceptor interceptor;
    private URLConnection contextConnection;
    private CookieHandler cookieHandler;
    private AtomicInteger requestCounter = new AtomicInteger(0);
    private boolean interceptAllRequests;

    public WebKitURLHandler(Interceptor interceptor, boolean interceptAllRequests) {
        this.interceptor = interceptor;
        this.interceptAllRequests = interceptAllRequests;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        int rcount = this.requestCounter.incrementAndGet();
        String protocol = u.getProtocol();
        if (!protocol.startsWith(UI4J_PROTOCOL)) {
            return null;
        }
        String url = u.toString().substring(protocol.length() + 1, u.toString().length());
        if (this.context == null && url.startsWith("http")) {
            this.context = url;
        }
        if (!(this.context == null || url.startsWith("http") || url.startsWith("/") || this.context.endsWith("/"))) {
            String f = u.getFile().replaceAll("https://", "");
            url = String.valueOf(this.context) + "/" + f;
        }
        URLConnection connection = new URL(url).openConnection();
        if (rcount == 1) {
            this.contextConnection = connection;
        }
        Request request = new Request(url);
        if (rcount == 1 && !this.interceptAllRequests) {
            this.interceptor.beforeLoad(request);
        } else if (this.interceptAllRequests) {
            this.interceptor.beforeLoad(request);
            URLConnection conn = request.getUrlConnection();
            if (conn != null) {
                return conn;
            }
        }
        if (request != null) {
            for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
                String key = entry.getKey();
                String value = String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue());
                connection.setRequestProperty(key, value);
            }
        }
        return connection;
    }

    public URLConnection getConnection() {
        return this.contextConnection;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }
}

