/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.webkit.spi;

import com.sun.webkit.dom.DocumentImpl;
import com.sun.webkit.dom.HTMLElementImpl;
import io.webfolder.ui4j.api.browser.SelectorEngine;
import io.webfolder.ui4j.api.dom.Document;
import io.webfolder.ui4j.api.dom.Element;
import io.webfolder.ui4j.spi.PageContext;
import io.webfolder.ui4j.webkit.browser.WebKitPageContext;
import io.webfolder.ui4j.webkit.dom.WebKitDocument;
import io.webfolder.ui4j.webkit.dom.WebKitElement;
import io.webfolder.ui4j.webkit.spi.WebKitJavaScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class W3CSelectorEngine
implements SelectorEngine {
    private PageContext context;
    private Document document;
    private WebKitJavaScriptEngine engine;

    public W3CSelectorEngine(PageContext context, Document document, WebKitJavaScriptEngine engine) {
        this.context = context;
        this.document = document;
        this.engine = engine;
    }

    @Override
    public Optional<Element> query(String selector) {
        DocumentImpl documentImpl = ((WebKitDocument)this.document).getDocument();
        String escapedSelector = selector.replace('\'', '\"');
        if (documentImpl == null) {
            return null;
        }
        org.w3c.dom.Element element = documentImpl.querySelector(escapedSelector);
        if (element != null) {
            return Optional.of(((WebKitPageContext)this.context).createElement(element, this.document, this.engine));
        }
        return Optional.empty();
    }

    @Override
    public List<Element> queryAll(String selector) {
        DocumentImpl documentImpl = ((WebKitDocument)this.document).getDocument();
        String escapedSelector = selector.replace('\'', '\"');
        if (documentImpl == null) {
            return Collections.emptyList();
        }
        NodeList nodes = documentImpl.querySelectorAll(escapedSelector);
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            elements.add(((WebKitPageContext)this.context).createElement(node, this.document, this.engine));
            ++i;
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return elements;
    }

    @Override
    public Optional<Element> query(Element element, String selector) {
        String escapedSelector;
        if (!(element instanceof WebKitElement)) {
            return null;
        }
        WebKitElement fxElementImpl = (WebKitElement)element;
        HTMLElementImpl elementImpl = fxElementImpl.getHtmlElement();
        org.w3c.dom.Element found = elementImpl.querySelector(escapedSelector = selector.replace('\'', '\"'));
        if (found == null) {
            return Optional.empty();
        }
        return Optional.of(((WebKitPageContext)this.context).createElement(found, this.document, this.engine));
    }

    @Override
    public List<Element> queryAll(Element element, String selector) {
        if (!(element instanceof WebKitElement)) {
            return Collections.emptyList();
        }
        WebKitElement fxElementImpl = (WebKitElement)element;
        HTMLElementImpl elementImpl = fxElementImpl.getHtmlElement();
        String escapedSelector = selector.replace('\'', '\"');
        NodeList nodes = elementImpl.querySelectorAll(escapedSelector);
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            elements.add(((WebKitPageContext)this.context).createElement(node, this.document, this.engine));
            ++i;
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return elements;
    }
}

