<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<link href="${pageContext.request.contextPath}/CSS/style.css" rel="stylesheet" type="text/css" > 

<title>League Teams</title>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<script src="${pageContext.request.contextPath}/WEB-INF/lib/jquery.rowselector.min.js"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script type="text/javascript">

$(document).ready(function() {
	$("#${tableName} > tbody > tr").each(function() {
       if($(this).attr("teamid") != '${teamID}')
       {
       		this.className='hidden';
       }
    });     
          
});	

$(window).load(function() {
	
	var cellP = $("td[name='player']");
	var nbPlayer = '${Tplayers.size()}';
	var tmp = generateColor('#ffd157','#ff0000',nbTeam/2);
	var tmp2 = generateColor('#00d700','#d6fa05',nbTeam/2);
	$.merge(tmp,tmp2);
	var z = 0;
	$(cellP).each(function() {
		for(x=0;x<nbPlayer;x++){	
    		if($(cellP).eq(z).text() < nbTeam - x +0.5 && $(cellP).eq(z).text() >= nbTeam - x -0.5){
    			$(this).css('background', 'linear-gradient(#'+tmp[x] + ', #' +tmp[x] + ')');
    		}
		}
		z+=1;
	});

   	function hex (c) {
   	  var s = "0123456789abcdef";
   	  var i = parseInt (c);
   	  if (i == 0 || isNaN (c))
   	    return "00";
   	  i = Math.round (Math.min (Math.max (0, i), 255));
   	  return s.charAt ((i - i % 16) / 16) + s.charAt (i % 16);
   	}

   	/* Convert an RGB triplet to a hex string */
   	function convertToHex (rgb) {
   	  return hex(rgb[0]) + hex(rgb[1]) + hex(rgb[2]);
   	}

   	/* Remove '#' in color hex string */
   	function trim (s) { return (s.charAt(0) == '#') ? s.substring(1, 7) : s }

   	/* Convert a hex string to an RGB triplet */
   	function convertToRGB (hex) {
   	  var color = [];
   	  color[0] = parseInt ((trim(hex)).substring (0, 2), 16);
   	  color[1] = parseInt ((trim(hex)).substring (2, 4), 16);
   	  color[2] = parseInt ((trim(hex)).substring (4, 6), 16);
   	  return color;
   	}

   	function generateColor(colorStart,colorEnd,colorCount){
   		// The beginning of your gradient
   		var start = convertToRGB (colorStart);    
   		// The end of your gradient
   		var end   = convertToRGB (colorEnd);    
   		// The number of colors to compute
   		var len = colorCount;
   		//Alpha blending amount
   		var alpha = 0.0;
   		var saida = [];
   		for (i = 0; i < len; i++) {
   			var c = [];
   			alpha += (1.0/len);
   			
   			c[0] = start[0] * alpha + (1 - alpha) * end[0];
   			c[1] = start[1] * alpha + (1 - alpha) * end[1];
   			c[2] = start[2] * alpha + (1 - alpha) * end[2];

   			saida.push(convertToHex (c));
   		}
   		return saida;
   	}
});	//end doc ready


 function RowClick(currenttr,table, otherTable) {

	$("#" + table +" > tbody > tr").each(function() {
		var tableRow = this;
		
        if($(tableRow).attr("id") == $(currenttr).attr("id"))
        {

        	if($(tableRow).attr("teamid") != $(tableRow).attr("tid")){
        		tableRow.className='hidden';
            	$("#" + otherTable +" > tbody > tr").each(function() {
                	var otableRow = this;
            		if(otableRow.className=='selected' && $(tableRow).attr("player") == $(otableRow).attr("player")){
            			otableRow.className ='tab';	
            		}
                });
        		
        	}else if(tableRow.className=='selected')
            {
            	tableRow.className='tab';
            	$("#" + otherTable +" > tbody > tr").each(function() {
                	var otableRow = this;
            		if(otableRow.className=='displayed' && $(tableRow).attr("player") == $(otableRow).attr("player")){
            			otableRow.className ='hidden';	
            		}
                });
            }else
            {
            	tableRow.className='selected';
            	$("#" + otherTable +" > tbody > tr").each(function() {
            		var otableRow = this;
            		if(otableRow.className=='hidden' && $(tableRow).attr("player") == $(otableRow).attr("player")){
            			otableRow.className ='displayed';	
            		}
            	});
            }
        }
    });
} 
</script>

</head>
<body>

<c:set var="players" value="${requestScope.Tplayers}" />
<c:set var="stats" value="${players[0].stats}" />

<table id="${tableName}" class="tableTrade" >

<thead>
<tr class="Header">
 <th align="left"><c:out value="Pos" /></th>
 <th align="left" style="width:120px"><c:out value="Players" /></th>
 <th align="left"><c:out value="Team RK" /></th>
 	<c:forEach var="stat" items= "${stats}" varStatus="i">
	 	<th ><c:out value="${stat.name}" /></th>	
	 </c:forEach>
</tr>
</thead>

<tbody style="font-size:16px;font-weight: bold; ">
<c:forEach var="player" items= "${players}" varStatus="i">
	<tr style="height:20px;" class="tab" id="${i.index}" tid="${teamID}" teamid="${player.teamID}" player="${player.nom}" onclick="RowClick(this,'${tableName}','${otherTableName}');">
	
	<c:set var="stats" value="${player.stats}" />
	
	  <td>
	  	<c:forEach items="${player.positions}" var="position">
		    <c:out value="${position}," />
		</c:forEach>
	  </td>
	  
      <td style="width:120px;text-align:left;" ><c:out value="${player.nom}" /></td>
      <td name="player" align="center"><fmt:formatNumber pattern="0.#" value="${player.interRK}" /></td>
      
      <c:forEach var="stat" items= "${stats}" varStatus="i">
	 	<td style="align:center"><c:out value="${stat.statVal}" /></td>	
	 </c:forEach>
      
    </tr>
</c:forEach>
</tbody>
</table>


</body>
</html>


